﻿function updateModelOnClickLink($links, callbackRequest, callbackResponse, targetModel) {
    $links.each(function (ix, el) {
        el.onclick = function () {
            var url = this.href.split("#")[0];     // strip anchors
            updateModel(url, null, callbackRequest, callbackResponse, targetModel);
            return false;
        }
    });
}

function updateModelOnFormSubmit($form, callbackRequest, callbackResponse, targetModel) {
    $form.bind("submit", function () {
        var url;
        var postData;
        if (!this.method || this.method.toUpperCase() == "GET") {
            var sep = this.action.indexOf('?') == -1 ? "?" : "&";
            url = this.action + sep + $(this).serialize();
            postData = null;
        } else {
            url = this.action;
            postData = $(this).serialize();
        }

        updateModel(url, postData, callbackRequest, callbackResponse, targetModel);
        return false;
    });
}

function updateModel(url, postData, callbackRequest, callbackResponse, targetModel) {
    if (!callbackRequest(url)) return false;
    var isHttpPost = (postData != null);
    $.ajax({
        url: url,
        type: isHttpPost ? "POST" : "GET",
        data: postData,
        dataType: "json",
        processData: true,
        beforeSend: function (xhr) {
            xhr.setRequestHeader("Content-Type", isHttpPost ? "application/x-www-form-urlencoded, application/json" : "application/json");
        },
        success: function (json) {
            if (targetModel) targetModel.set_data(json);
            callbackResponse(json);
        }
    });
}